clear all;close all;clc;
addpath baseline;
addpath tools;
%% Rayleigh channel, narrow-band

%% basic simulation settings
M = 32;              % the number of BS antennas
N = 256;             % the number of RIS elements
L = 2;               % the number of transmitter antennas 
                     % in the large-timescale channel estimation

%% system power settings
Tx_power_BS = 10;

%% large-scale fading settings
D_ref = 1;
sigma2_ref = 0.01;
D_G = 10;
alpha_G = 2.1;
sigma2_G = sigma2_ref*(D_ref/D_G)^alpha_G;

%% Monte-Carlo simulation settings
N_trial = 100;
SINR_L_list = [0,10,20];
I_max = 5;
Convergence = zeros(numel(SINR_L_list),I_max+1,N,N_trial);
Convergence_mat = zeros(numel(SINR_L_list),I_max+1,N*N_trial);

%% begin Monte-Carlo simulations
for SNR_idx = 1:numel(SINR_L_list);
    SINR_L = SINR_L_list(SNR_idx);
    SI_plus_noise_power = Tx_power_BS*(N*sigma2_G^2)*10^(-SINR_L/10);
    for trial_idx = 1:N_trial
        %% generate the channels
        G = (normrnd(0,1,M,N) + 1i*normrnd(0,1,M,N))*sqrt(sigma2_G/2); % the channel matrix between the BS and the RIS
        S = (normrnd(0,1,M,M) + 1i*normrnd(0,1,M,M))*sqrt(1/2)*10; % self-interference channel

    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%  
    %% %%%%%%%% THE PROPOSED CHANNEL ESTIMATION FRAMEWORK %%%%%%%% %%
    %% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%
        %% Phase 1: estimating the channel between the BS and the RIS
        options_Phase1 = struct;
        options_Phase1.M = M;
        options_Phase1.N = N;
        options_Phase1.SI_plus_noise_var = SI_plus_noise_power;
        options_Phase1.Tx_power = Tx_power_BS;
        options_Phase1.L = L;
        options_Phase1.Tx_id = 1:L;
        options_Phase1.sigma2_G = sigma2_G;
        options_Phase1.I_max = I_max; % max number of outer iterations in the coordinate descent in phase-1
        Phi = dftmtx(N+1); 
        Y = ReflectionPilotTransmission( G, S*sqrt(SI_plus_noise_power), Phi, options_Phase1 ); % pilot transmission, reflection, and reception
        [G_est, Convergence(SNR_idx,:,:,trial_idx)] = ReflectionChannelEstimation( Y, Phi, options_Phase1, G ); % run Algorithm 1 to estimate the channel

        disp(['SNR=',num2str(SINR_L),'  trial=',num2str(trial_idx),',    noise=',num2str(10*log10(SI_plus_noise_power)),'dB,    method=MINE']);
    end
    
    for i=1:N
        for j=1:N_trial
            Convergence_mat(SNR_idx,:,(i-1)*N_trial+j) = Convergence(SNR_idx,:,i,j)/((sigma2_G^2+SI_plus_noise_power/(N+1)/Tx_power_BS)*L*(M-1));
        end
    end
end

figure;
semilogy(0:1:I_max,mean(squeeze(Convergence_mat(1,:,:)),2),'b-d','LineWidth',1.5);
hold on;
std_conv = zeros(I_max+1,1);
for i=1:I_max+1
    std_conv(i) = std(squeeze(Convergence_mat(1,i,:)));
end
errorbar(0:1:I_max,mean(squeeze(Convergence_mat(1,:,:)),2),std_conv,'b-d','LineWidth',1.5);

hold on;
semilogy(0:1:I_max,mean(squeeze(Convergence_mat(2,:,:)),2),'r-v','LineWidth',1.5);
hold on;
std_conv = zeros(I_max+1,1);
for i=1:I_max+1
    std_conv(i) = std(squeeze(Convergence_mat(2,i,:)));
end
errorbar(0:1:I_max,mean(squeeze(Convergence_mat(2,:,:)),2),std_conv,'r-v','LineWidth',1.5);

hold on;
p=semilogy(0:1:I_max,mean(squeeze(Convergence_mat(3,:,:)),2),'r-^','LineWidth',1.5);
set(p,'Color',[0.8 0 0.8]);
hold on;
std_conv = zeros(I_max+1,1);
for i=1:I_max+1
    std_conv(i) = std(squeeze(Convergence_mat(3,i,:)));
end
p=errorbar(0:1:I_max,mean(squeeze(Convergence_mat(3,:,:)),2),std_conv,'r-^','LineWidth',1.5);
set(p,'Color',[0.8 0 0.8]);

grid on;
h=xlabel('$i$');
set(h,'interpreter','latex');
h=ylabel('$\bar f_n^{(i)}$');
set(h,'interpreter','latex');
legend('median case','worst case','best case');
save convergence.mat